<?php

class BeritaAcaraDaftarHadirController extends Controller {

    /**
     * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
     * using two-column layout. See 'protected/views/layouts/column2.php'.
     */
    public $layout = '//layouts/column2';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'view', 'validate'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('create', 'update'),
                'users' => array('@'),
            ),
            array('allow', // allow admin user to perform 'admin' and 'delete' actions
                'actions' => array('admin', 'delete'),
                'users' => array('admin'),
            ),
                /* array('deny',  // deny all users
                  'users'=>array('*'),
                  ), */
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id) {
        $this->render('view', array(
            'model' => $this->loadModel($id),
        ));
    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    public function actionCreate() {
        $model = new BeritaAcaraDaftarHadir;

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['BeritaAcaraDaftarHadir'])) {
            $model->attributes = $_POST['BeritaAcaraDaftarHadir'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->ID));
        }

        $this->render('create', array(
            'model' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id) {
        $model = $this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

        if (isset($_POST['BeritaAcaraDaftarHadir'])) {
            $model->attributes = $_POST['BeritaAcaraDaftarHadir'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->ID));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id) {
        if (Yii::app()->request->isPostRequest) {
// we only allow deletion via POST request
            $this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if (!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else
            throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
    }
    
    public function actionCetakLaporan($id) {
        $html2pdf = Yii::app()->pdf->HTML2PDF('L', array(210,330), 'en', true, 'UTF-8', array(15, 10, 10, 10));
        $message = $id;
        $html2pdf->WriteHTML($this->renderPartial('LaporanBeritaAcaraKuliah', array('message' => $message), true));
        ob_end_clean();
        $html2pdf->Output('BeritaAcaraDH_' . $id . '.pdf');
    }

    /**
     * Lists all models.
     */
    public function actionIndex() {
        $dataProvider = new CActiveDataProvider('BeritaAcaraDaftarHadir');
        $this->render('index', array(
            'dataProvider' => $dataProvider,
        ));
    }

    /**
     * Manages all models.
     */
    public function actionAdmin() {
        $model = new BeritaAcaraDaftarHadir('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['BeritaAcaraDaftarHadir']))
            $model->attributes = $_GET['BeritaAcaraDaftarHadir'];

        $this->render('admin', array(
            'model' => $model,
        ));
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id) {
        $model = BeritaAcaraDaftarHadir::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

    public function actionsearchBeritaAcaraDaftarHadir() {
        $model = new BeritaAcaraDaftarHadir;

        // Uncomment the following line if AJAX validation is needed
        // $this->performAjaxValidation($model);

        $KODE_MK_form = "";
        $Sem = "";
        $Kelas_form = "";
        $T_A = "";
        if (isset($_POST['BeritaAcaraDaftarHadir'])) {
            //$model->attributes = $_POST['BeritaAcaraKuliah'];
            $KODE_MK_form = $_POST['BeritaAcaraDaftarHadir']['KODE_MK'];
            $Sem_form = $_POST['BeritaAcaraDaftarHadir']['SEM'];
            $Kelas_form = $_POST['BeritaAcaraDaftarHadir']['KELAS'];
            $T_A = $_POST['BeritaAcaraDaftarHadir']['TA'];
            $id = $KODE_MK_form . "-" . $Sem_form . "-" . $Kelas_form . "-" . $T_A;
            $hasil = BeritaAcaraDaftarHadir::model()->findAllByAttributes(array('KODE_MK' => $KODE_MK_form, 'KELAS' => $Kelas_form, 'SEM' => $Sem_form));
            $hadir= Yii::app()->db->createCommand("SELECT COUNT(*) FROM berita_acara_daftar_hadir where KODE_MK LIKE '$KODE_MK_form' AND SEM LIKE '$Sem_form' AND KELAS LIKE '$Kelas_form' AND TA LIKE '$T_A' AND STATUS LIKE 'H'")->queryAll();
            $absen= Yii::app()->db->createCommand("SELECT COUNT(*) FROM berita_acara_daftar_hadir where KODE_MK LIKE '$KODE_MK_form' AND SEM LIKE '$Sem_form' AND KELAS LIKE '$Kelas_form' AND TA LIKE '$T_A' AND STATUS LIKE 'A'")->queryAll();
            var_dump($hadir);
            $jmlHadir = 0;
            foreach($hadir as $item)
            {
                $jmlHadir =  $item['COUNT(*)'];
            }
            $jmlabsen = 0;
            foreach ($absen as $item)
            {
                $jmlabsen = $item['COUNT(*)'];
            }
            if ($hasil)
                $this->redirect(array('IndexData', 'id' => $id,'lapet' => $jmlHadir,'lapet2'=>$jmlabsen));
        }

        $this->render('SearcHDaftarHadir', array(
            'model' => $model,
        ));
    }

    public function actionIndexData($id, $lapet, $lapet2) {
        //$dataProvider = new CActiveDataProvider('BeritaAcaraKuliah');
        //
        //echo $lapet;
        //echo $lapet2;
        //var_dump($lapet) ;
        $this->render('IndexDataSearch', array(
            'message' => $id, 'wew'=>$lapet, 'wow'=>$lapet2,
        ));
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'berita-acara-daftar-hadir-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionValidate($rfid, $nim) {

        $tanggal = date('Y-m-d');
        $waktu = date('H:i:s');
        $sql = "SELECT * FROM jadwal WHERE ((RUANGAN='$rfid' AND  TANGGAL ='$tanggal') AND ('$waktu' BETWEEN jadwal.`START_TIME` AND jadwal.`END_TIME`)) 
AND KELAS IN (SELECT KELAS FROM registrasi WHERE registrasi.`NIM`='$nim' ORDER BY SEM DESC)";

        $list = Yii::app()->db->createCommand($sql)->queryAll();
        if ($list) {
            $kehadiran = BeritaAcaraDaftarHadir::model()->findByAttributes(
                    array(
                        'WEEK' => $list[0]['WEEK'],
                        'TANGGAL' => $list[0]['TANGGAL'],
                        'SESSION' => $list[0]['SESSION'],
                        'START_TIME' => $list[0]['START_TIME'],
                        'END_TIME' => $list[0]['END_TIME'],
                        'KODE_MK' => $list[0]['KODE_MK'],
                        'NIM' => $nim,
                    )
            );

            if ($this->cekKehadiran($kehadiran->STATUS)) {
                $kehadiran->STATUS = 'H';
                $kehadiran->WAKTU_ABSEN = $waktu;
                $kehadiran->save();
                echo "Berhasil";
            } else {
                echo "Gagal";
            }

//            $this->render('index', array(
//                'dataProvider' => $dataProvider,
//            ));
        } else {
//            var_dump($list);
//            $this->render('admin', array(
//                'model' => $model,
//            ));
            echo "Gagal";
        }
    }

}
