@if(Sentinel::check())
    @extends('layouts.master-manager')
@section('content')

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">
            <div class="page-title">
                <div class="title_left">
                    <h4> <a href="{{url('/manager')}}" class="fa fa-home"> Home</a> / <a href="{{url('/viewpengunjung')}}">Daftar Pengunjung</a> </h4>
                </div>
            </div>

            <div class="clearfix"></div>

            <div class="row">

                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Data Penjualan Tiket</h2>

                            <div class="clearfix"></div>

                        </div>
                        <div class="x_content">
                            @if (Session::has('pesan_sukses'))
                                <div class="alert alert-success">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                    {{ Session::get('pesan_sukses') }}
                                </div>
                            @elseif (Session::has('pesan_gagal'))
                                <div class="alert alert-danger">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                    {{ Session::get('pesan_gagal') }}
                                </div>
                            @endif
                            <table id="datatable-buttons" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Nama Pengunjung</th>
                                    <th>Jumlah Tiket</th>
                                    <th>Total harga</th>
                                    <th>Tanggal Berkunjung</th>
                                    <th>Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $no=1; ?>
                                @foreach($pengunjungs as $pengunjung)
                                    <tr>
                                        <td>{{$no++}}</td>
                                        <td>{{$pengunjung->nama_pengunjung}}</td>
                                        <td>{{$pengunjung->jumlah}}</td>
                                        <td>{{$pengunjung->total_harga}}</td>
                                        <td>{{$pengunjung->created_at}}</td>
                                        <td>Dibayar</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- /page content -->
@endsection
@endif
