<?php

namespace App\Http\Controllers;
use App\data_person;
use Illuminate\Http\Request;

use App\Http\RequestS\dataPersonRequest;

class dataPersonController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data_persons = data_person::all();
        //$search = \Request::get('search');
        //echo $search;
        //$data_persons = data_person::Where('id = 1');

        return view('data_person.index',compact('data_persons'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('data_person.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(dataPersonRequest $request)
    {
        data_person::create($request->all());
        return redirect()->route('data_person.index')->with('message','Data Person has been create');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(data_person $data_person)
    {
        echo $data_person->id;
        return view('data_person.edit',compact('data_person'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(dataPersonRequest $request, data_person $data_person)
    {
        $data_person->update($request->all());
        return redirect()->route('data_person.index')->with('message','Data Person has been updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(data_person $data_person)
    {
        $data_person->delete();
        return redirect()->route('data_person.index')->with('message','Data Person has been deleted');
    }
}
