<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\Requests;

class HelpController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user_id = Auth::user()->id;
        $UFrequests = DB::table('requests')->join('courses', 'courses.id', '=', 'requests.course_id')
                                           ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                           ->join('classes', 'classes.id', '=', 'requests.class_id')
                                           // ->join('invitations', 'invitations.request_id', '=', 'requests.id')
                                           ->join('users', 'users.id', '=', 'requests.requester_id')
                                           // ->where('invitations.to_id', $user_id)
                                           // ->where('invitations.status', NULL)
                                           ->where('requester_id', '<>', $user_id)
                                           ->where('requests.status', 'Requested')
                                           ->get(array('rooms.name as room_name',
                                                       'courses.name as course_name',
                                                       'requests.*', 
                                                       'classes.name as class_name',
                                                       'users.name as requester'));

        $UFrequestsAp = DB::table('requests')->join('courses', 'courses.id', '=', 'requests.course_id')
                                             ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                             ->join('classes', 'classes.id', '=', 'requests.class_id')
                                             ->join('invitations', 'invitations.request_id', '=', 'requests.id')
                                             ->join('users as requester', 'requester.id', '=', 'requests.requester_id')
                                             ->join('users as approver', 'approver.id', '=', 'requests.approver_id')
                                             ->where('invitations.to_id', $user_id)
                                             ->where('requests.status', 'On Progress')
                                             ->where('requester_id', '<>', $user_id)
                                             ->where('approver_id', '<>', $user_id)
                                             ->get(array('rooms.name as room_name',
                                                         'courses.name as course_name', 
                                                         'requests.*', 
                                                         'classes.name as class_name',
                                                         'requester.name as requester',
                                                         'approver.name as approver'));                                 
        // dd($UFrequests);
        return view('helps.index')->with('UFrequests', $UFrequests)
                                  ->with('UFrequestsAp', $UFrequestsAp);
    }

    public function accepted()
    {
        $user_id = Auth::user()->id;
        $UFrequests = DB::table('requests')->join('courses', 'courses.id', '=', 'requests.course_id')
                                           ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                           ->join('classes', 'classes.id', '=', 'requests.class_id')
                                           ->where('approver_id', $user_id)
                                           ->where('status', 'On Progress')
                                           ->get(array('rooms.name as room_name','courses.name as course_name', 'requests.*', 'classes.name as class_name'));

       

        return view('helps.accepted')->with('UFrequests', $UFrequests);
    }

    public function finished()
    {
        $user_id = Auth::user()->id;
        $UFrequests = DB::table('requests')->join('courses', 'courses.id', '=', 'requests.course_id')
                                           ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                           ->join('classes', 'classes.id', '=', 'requests.class_id')
                                           ->where('approver_id', $user_id)
                                           ->where('status', 'Finish')
                                           ->where('requests.approver_id', $user_id)
                                           ->get(array('rooms.name as room_name','courses.name as course_name', 'requests.*', 'classes.name as class_name'));

       

        return view('helps.accepted')->with('UFrequests', $UFrequests);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function accept($id){
        $help = Requests::find($id);

        
        $help->status = 'On Progress';
        $help->approver_id = Auth::user()->id;
        $help->update();

        return redirect('/help');
    }
}
