<?php
Use App\Models\Bus;
Use App\Models\Supir;
Use App\Models\Users;
Use App\Models\Pemesanan;
Use App\Models\Batal;
use App\Models\Konfirmasi;
use App\Models\Jadwal;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/',function(){
	return view('index');
})->middleware('guest');

// Routing untuk authentifikasi
Route::group(['namespace' => 'auth'],function(){
	Route::post('/login','LoginController@login')->name('login');
    Route::get('/logout',function(){
        Auth::logout();
        return redirect('/');
    })->name('logout');
    Route::get('/register','RegisterController@store');
});


Route::group(['prefix' => 'admin','middleware' => 'admin'], function() {
    Route::get('/', function () {
        $this->data['title'] = 'Dashboard';                        
        return view('admin.index',$this->data);
    });
    Route::resource('admin','AdminController');
    Route::post('/store','AdminController@store');
    Route::get('/user','AdminController@user');
    Route::get('/user/tambah','AdminController@tambahuser');
    Route::get('/user/hapus/{id}','AdminController@hapususer');

    Route::get('/bus','AdminController@bus');
    Route::get('/bus/detail/{id}','AdminController@detail');
    Route::get('/bus/ubah/{id}','AdminController@ubah');
    Route::get('/bus/ubahgambar/{id}','AdminController@ubahgambar');
    Route::get('/bus/hapus/{id}','AdminController@hapusbus');
    Route::post('/ubah/{id}','AdminController@edit');
    Route::post('/ubahgambar/{id}','AdminController@editgambar');
    Route::get('/bus/tambah','AdminController@tambahbus');
    Route::post('/storebus','AdminController@storebus');

    Route::get('/supir','AdminController@supir');
    Route::get('/supir/tambah','AdminController@tambahsupir');
    Route::post('/storesupir','AdminController@storesupir');
    Route::get('/supir/hapus/{id}','AdminController@hapussupir');
    Route::get('/supir/detail/{id}','AdminController@detailsupir');
    Route::get('/supir/ubahsupir/{id}','AdminController@ubahsupir');
    Route::post('/ubahsupir/{id}','AdminController@editsupir');

    Route::get('/profil','AdminController@profil');

    Route::get('/history','AdminController@history');
    Route::get('/history/hapus/{id}','AdminController@hapus_history');
    Route::get('/history/hapus2/{id}','AdminController@hapus_history2');
    Route::get('/pemesanan','AdminController@pemesanan');
    Route::get('/pemesanan/detail/{id}','AdminController@detailpemesanan');
    Route::get('/pemesanan/tolak/{id}','AdminController@tolak');
    Route::post('/pemesanan/konfirmasi/{id}','AdminController@konfirmasi');

    Route::get('/coba','AdminController@coba');
    Route::post('/addbus','AdminController@addbus');
});

Route::group(['prefix' => 'k_supir','middleware' => 'k_supir'], function() {
    Route::get('/', function () {
        $this->data['title'] = 'Dashboard';
        return view('k_supir.index',$this->data);
    });
    Route::post('/storebus','K_SupirController@storebus');
    Route::get('/bus','K_SupirController@bus');
    Route::get('/bus/detail/{id}','K_SupirController@detail');
    Route::get('/pemesanan','K_SupirController@pemesanan');
    Route::get('/pemesanan/detail/{id}','K_SupirController@detailpemesanan');
    Route::get('/pemesanan/tolak/{id}','K_SupirController@tolak');
    Route::post('/pemesanan/konfirmasi/{id}','K_SupirController@konfirmasi');
    Route::get('/pemesanan/pilih','K_SupirController@pilih');
    Route::get('/pemesanan/pilih_bus/{id}','K_SupirController@pilih_bus');
    Route::get('/history','K_SupirController@history');
    Route::get('/history/detail/{id}','K_SupirController@history_detail');
    Route::get('/supir','K_SupirController@supir');
    Route::get('/supir/detail/{id}','K_SupirController@detailsupir');
    Route::get('/supir/jadwal','K_SupirController@jadwal');
    Route::get('/supir/update_jadwal','K_SupirController@update_jadwal');
    Route::get('/supir/invoice-print','K_SupirController@invoice_print');

});

Route::group(['prefix' => 'klien','middleware' => 'klien'], function() {
    Route::get('/', function () {
        $this->data['title'] = 'Dashboard';
        return view('klien.index',$this->data);
    });
    Route::resource('klien','KlienController');
    Route::get('/pesan','KlienController@pesan');
    Route::get('/pesan/pilih','KlienController@pilih');
    Route::post('/pemesanan','KlienController@pemesanan');
    Route::get('/bus','KlienController@bus');
    Route::get('/bus/detail/{id}','KlienController@detail');
    Route::get('/history','KlienController@history');
    Route::get('/status','KlienController@status');
    Route::get('/pemesanan/batal/{id}','KlienController@batal');
    Route::get('/pesan/pilih_bus/{id}','KlienController@pilih_bus');
    Route::get('/status/batal/{id}','KlienController@batal');
    Route::post('/kirim_pembatalan','KlienController@kirim_pembatalan');
    Route::get('/history/detail/{id}','KlienController@history_detail');
    Route::get('/history/detail2/{id}','KlienController@history_detail2');
    Route::get('/profil','KlienController@profil');
    Route::get('/profil/ubah','KlienController@ubah_profil');
});