@if(Auth::check())
    @extends('layouts.layout')
    @include('layouts.header')

    <body class="skin-blue sidebar-mini" style="height: auto;">
    <div class="wrapper" style="height: auto;">
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section id="content-menu" class="content-menu">
                <div class="module-menu-container"></div>
                <ol class="breadcrumb"><li><a href="/"><i class="fa-home"></i> Home</a></li>
                    <li class="active"><i class="fa-users"></i>Supir</li>
                </ol><!-- breadcrumbs -->
            </section>

            <!-- Main content -->
            <section class="content">
                <!-- /.row -->
                <div class="row">
                    <div class="col-xs-12">
                        <div class="box box-primary">
                            <div class="box-header">
                                <h3 class="box-title">Supir</h3>
                                <div class="box-tools">
                                    <form action="{{url('/admin/supir')}}">
                                        <div class="input-group input-group-sm" style="width: 150px;">
                                            <input type="text" name="search" class="form-control pull-right"
                                                   placeholder="Username" id="search" type="text">
                                            <div class="input-group-btn">
                                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="form-group">
                                    <?php $jumlah=0 ?>
                                    @foreach($total as $tot)
                                        <?php $jumlah++ ?>
                                    @endforeach
                                    <h4>Total Supir = {{$jumlah}}</h4>
                                </div>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body table-responsive no-padding">
                                <table class="table table-hover">
                                    <thead><tr>
                                        <th>Nama Supir</th>
                                        <th>ID Supir</th>
                                        <th>Aksi</th>
                                    </tr></thead>
                                    <tbody>
                                    @foreach($supir as $supi)
                                        <tr>
                                            <td>{{$supi->nama_supir}}</td>
                                            <td>{{$supi->id}}</td>
                                            <td colspan="2">
                                                <a href="{{url('admin/supir/detail',$supi->id)}}" class="btn btn-danger">Detail</a>
                                                <a href="{{url('admin/supir/hapus',$supi->id)}}" class="btn btn-danger">Hapus</a>
                                            </td>
                                        </tr>
                                        </form>
                                    @endforeach
                                    </tbody>
                                </table>
                                {{$supir->links()}}
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <a href="{{url('admin/supir/tambah')}}" class="btn btn-danger">Tambah Supir</a>
                                <i fa-user-plus></i>
                            </div>
                        </div>
                        <!-- /.box -->
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
    </body>
@endif