/*!
 * @package   yii2-grid
 * @author    Kartik Visweswaran <kartikv2@gmail.com>
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2014 - 2016
 * @version   3.1.3
 *
 * Grid Export Validation Module for Yii's Gridview. Supports export of
 * grid data as CSV, HTML, or Excel.
 *
 * Author: Kartik Visweswaran
 * Copyright: 2015, Kartik Visweswaran, Krajee.com
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */!function(a){"use strict";var b,c,d,e,f,g,h="urn:schemas-microsoft-com:office:";b=function(a,b,c){return a.split(b).join(c)},c=function(b,c){return null===b||void 0===b||0===b.length||c&&""===a.trim(b)},d=function(a,b,c,d){var e=screen.width/2-c/2,f=60,g=window.open("",b,"",!0);return g.close(),window.open(a,b,"toolbar=no, location=no, directories=no, status=yes, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width="+c+", height="+d+", top="+f+", left="+e)},e=function(a){return a.toLowerCase().replace(/[^\w ]+/g,"").replace(/ +/g,"-")},f={html:'<!DOCTYPE html><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/><meta http-equiv="X-UA-Compatible" content="IE=edge;chrome=1"/>{css}<style>.kv-wrap{padding:20px;}.kv-align-center{text-align:center;}.kv-align-left{text-align:left;}.kv-align-right{text-align:right;}.kv-align-top{vertical-align:top!important;}.kv-align-bottom{vertical-align:bottom!important;}.kv-align-middle{vertical-align:middle!important;}.kv-page-summary{border-top:4px double #ddd;font-weight: bold;}.kv-table-footer{border-top:4px double #ddd;font-weight: bold;}.kv-table-caption{font-size:1.5em;padding:8px;border:1px solid #ddd;border-bottom:none;}</style><body class="kv-wrap">{data}</body>',pdf:"{before}\n{data}\n{after}",excel:'<html xmlns:o="'+h+'office" xmlns:x="'+h+'excel" xmlns="http://www.w3.org/TR/REC-html40"><head><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/>{css}<!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body>{data}</body></html>',popup:'<html style="display:table;width:100%;height:100%;"><title>Grid Export - &copy; Krajee</title><body style="display:table-cell;font-family:Helvetica,Arial,sans-serif;color:#888;font-weight:bold;line-height:1.4em;text-align:center;vertical-align:middle;width:100%;height:100%;padding:0 10px;">{msg}</body></html>'},g=function(b,c){var d=this,e=c.gridOpts,f=c.genOpts;d.$element=a(b),d.gridId=e.gridId,d.$grid=a("#"+e.gridId),d.dialogLib=c.dialogLib,d.messages=e.messages,d.target=e.target,d.exportConversions=e.exportConversions,d.showConfirmAlert=e.showConfirmAlert,d.filename=f.filename,d.showHeader=f.showHeader,d.showFooter=f.showFooter,d.showPageSummary=f.showPageSummary,d.$table=d.$grid.find(".kv-grid-table:first"),d.$form=d.$grid.find("form.kv-export-form"),d.encoding=d.$form.find('[name="export_encoding"]').val(),d.columns=d.showHeader?"td,th":"td",d.alertMsg=c.alertMsg,d.config=c.config,d.popup="",d.listen()},g.prototype={constructor:g,getArray:function(b){var d=this,f=d.clean(b),g=[],h={};return void 0!==d.config.colHeads&&d.config.colHeads.length>0?g=d.config.colHeads:f.find("thead tr th").each(function(b){var f=a(this).text().trim(),h=e(f);g[b]=!d.config.slugColHeads||c(h)?"col_"+b:h}),f.find('tbody tr:has("td")').each(function(b){h[b]={},a(this).children("td").each(function(c){var d=g[c];h[b][d]=a(this).text().trim()})}),h},setPopupAlert:function(a){var b=this;if(void 0!==b.popup.document)if(arguments.length&&arguments[1]){var c=b.popup.document.getElementsByTagName("body");setTimeout(function(){c[0].innerHTML=a},4e3)}else{var d=f.popup.replace("{msg}",a);b.popup.document.write(d)}},processExport:function(a,b){var d=this;setTimeout(function(){c(b)?d[a]():d[a](b)},100)},listenClick:function(a){var b=this,d=arguments.length>1?arguments[1]:"",e=window[b.dialogLib];b.$element.off("click.gridexport").on("click.gridexport",function(f){if(f.stopPropagation(),f.preventDefault(),!b.showConfirmAlert)return void b.processExport(a,d);var g=b.messages,h=c(b.alertMsg)?"":b.alertMsg,i=c(g.allowPopups)?"":g.allowPopups,j=c(g.confirmDownload)?"":g.confirmDownload,k="";return k=h.length&&i.length?h+"\n\n"+i:!h.length&&i.length?i:h.length&&!i.length?h:"",j.length&&(k=k+"\n\n"+j),c(k)?void 0:(e.confirm(k,function(c){c&&b.processExport(a,d),f.preventDefault()}),!1)})},listen:function(){var a=this;"_popup"===a.target&&a.$form.on("submit.gridexport",function(){setTimeout(function(){a.setPopupAlert(a.messages.downloadComplete,!0)},1e3)}),a.$element.hasClass("export-csv")&&a.listenClick("exportTEXT","csv"),a.$element.hasClass("export-txt")&&a.listenClick("exportTEXT","txt"),a.$element.hasClass("export-html")&&a.listenClick("exportHTML"),a.$element.hasClass("export-xls")&&a.listenClick("exportEXCEL"),a.$element.hasClass("export-json")&&a.listenClick("exportJSON"),a.$element.hasClass("export-pdf")&&a.listenClick("exportPDF")},clean:function(b){var c=this,d=c.$table.clone(),e=c.$table.closest(".kv-grid-container").find(".kv-thead-float thead"),f=function(a){d.find(a+"."+c.gridId).remove()};e.length&&(e=e.clone(),d.find("thead").before(e).remove()),d.find("tr.filters").remove(),d.find("th").removeAttr("rowspan"),d.find("th").find("a").each(function(){a(this).contents().unwrap()}),d.find("input").remove(),c.showHeader||d.children("thead").remove(),c.showPageSummary||f(".kv-page-summary-container"),c.showFooter||f(".kv-footer-container"),c.showCaption||f(".kv-caption-container"),d.find(".skip-export").remove(),d.find(".skip-export-"+b).remove();var g=d.html();return g=c.preProcess(g),d.html(g),d},preProcess:function(a){var g,c=this,d=c.exportConversions,e=d.length,f=a;if(e>0)for(var h=0;h<e;h++)g=d[h],f=b(f,g.from,g.to);return f},download:function(a,b){var e=this,f=e.$element.data("format"),g=c(e.config)?{}:e.config;e.$form.find('[name="export_filetype"]').val(a),e.$form.find('[name="export_filename"]').val(e.filename),e.$form.find('[name="export_content"]').val(b),e.$form.find('[name="export_mime"]').val(f),"pdf"===a?e.$form.find('[name="export_config"]').val(JSON.stringify(g)):e.$form.find('[name="export_config"]').val(""),"_popup"===e.target&&(e.popup=d("","kvDownloadDialog",350,120),e.popup.focus(),e.setPopupAlert(e.messages.downloadProgress)),e.$form.submit()},exportHTML:function(){var b=this,c=b.clean("html"),d=b.config,e=b.config.cssFile&&d.cssFile.length?'<link href="'+b.config.cssFile+'" rel="stylesheet">':"",g=f.html.replace("{encoding}",b.encoding).replace("{css}",e).replace("{data}",a("<div />").html(c).html());b.download("html",g)},exportPDF:function(){var b=this,d=b.clean("pdf"),e=c(b.config.contentBefore)?"":b.config.contentBefore,g=c(b.config.contentAfter)?"":b.config.contentAfter,h=b.config.css,i=f.pdf.replace("{css}",h).replace("{before}",e).replace("{after}",g).replace("{data}",a("<div />").html(d).html());b.download("pdf",i)},exportTEXT:function(b){var c=this,d=c.clean(b),e=d.find("tr:has("+c.columns+")"),f=String.fromCharCode(11),g=String.fromCharCode(0),h='"'+c.config.colDelimiter+'"',i='"'+c.config.rowDelimiter+'"',j='"'+e.map(function(b,d){var e=a(d),g=e.find(c.columns);return g.map(function(b,c){var d=a(c),e=d.text().trim();return e.replace(/"/g,'""')}).get().join(f)}).get().join(g).split(g).join(i).split(f).join(h)+'"';c.download(b,j)},exportJSON:function(){var a=this,b=a.getArray("json");b=JSON.stringify(b,a.config.jsonReplacer,a.config.indentSpace),a.download("json",b)},exportEXCEL:function(){var e,g,b=this,c=b.clean("xls"),d=b.config,h=d.cssFile&&b.config.cssFile.length?'<link href="'+b.config.cssFile+'" rel="stylesheet">':"";c.find("td[data-raw-value]").each(function(){g=a(this),(g.css("mso-number-format")||0===g.css("mso-number-format")||"0"===g.css("mso-number-format"))&&g.html(g.attr("data-raw-value")).removeAttr("data-raw-value")}),e=f.excel.replace("{encoding}",b.encoding).replace("{css}",h).replace("{worksheet}",b.config.worksheet).replace("{data}",a("<div />").html(c).html()).replace(/"/g,"'"),b.download("xls",e)}},a.fn.gridexport=function(b){var c=Array.apply(null,arguments);return c.shift(),this.each(function(){var d=a(this),e=d.data("gridexport"),f="object"==typeof b&&b;e||d.data("gridexport",e=new g(this,a.extend({},a.fn.gridexport.defaults,f,a(this).data()))),"string"==typeof b&&e[b].apply(e,c)})},a.fn.gridexport.defaults={dialogLib:"krajeeDialog"},a.fn.gridexport.Constructor=g}(window.jQuery);