<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_peserta_toefl".
 *
 * @property integer $peserta_toefl_id
 * @property integer $user_id
 * @property string $nama_peserta
 * @property string $tanggal_lahir
 * @property string $alamat
 * @property string $telp
 * @property string $email
 * @property integer $biaya_id
 * @property string $sumber_informasi
 * @property string $tanggal_ujian
 * @property string $tujuan_toefl
 * @property string $pengambilan_hasil
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property BhsxNilaiToefl[] $bhsxNilaiToefls
 * @property BhsxPembayaranToefl[] $bhsxPembayaranToefls
 * @property BhsxRBiayaToefl $biaya
 * @property SysxUser $user
 */
class PesertaToefl extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_peserta_toefl';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
        //'user_id',
            [[ 'nama_peserta', 'tanggal_lahir', 'alamat', 'telp', 'email', 'sumber_informasi', 'tanggal_ujian', 'tujuan_toefl', 'pengambilan_hasil'], 'required'],
            //[['user_id', 'biaya_id', 'deleted'], 'integer'],
            [['tanggal_lahir', 'tanggal_ujian', 'created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['alamat'], 'string'],
            [['nama_peserta'], 'string', 'max' => 40],
            [['telp'], 'string', 'max' => 25],
            [['email', 'sumber_informasi', 'pengambilan_hasil'], 'string', 'max' => 20],
            [['tujuan_toefl'], 'string', 'max' => 50],
            //[['created_by', 'updated_by'], 'string', 'max' => 45],
            //[['deleted_by'], 'string', 'max' => 32],
          //  [['biaya_id'], 'exist', 'skipOnError' => true, 'targetClass' => BiayaToefl::className(), 'targetAttribute' => ['biaya_id' => 'biaya_id']],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'user_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'peserta_toefl_id' => 'Peserta Toefl ID',
            'user_id' => 'User ID',
            'nama_peserta' => 'Nama Peserta',
            'tanggal_lahir' => 'Tanggal Lahir',
            'alamat' => 'Alamat',
            'telp' => 'Telp',
            'email' => 'Email',
            'biaya_id' => 'Biaya ID',
            'sumber_informasi' => 'Sumber Informasi',
            'tanggal_ujian' => 'Tanggal Ujian',
            'tujuan_toefl' => 'Tujuan Toefl',
            'pengambilan_hasil' => 'Pengambilan Hasil',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNilaiToefls()
    {
        return $this->hasMany(NilaiToefl::className(), ['peserta_toefl_id' => 'peserta_toefl_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPembayaranToefls()
    {
        return $this->hasMany(PembayaranToefl::className(), ['peserta_toefl_id' => 'peserta_toefl_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBiaya()
    {
        return $this->hasOne(BiayaToefl::className(), ['biaya_id' => 'biaya_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['user_id' => 'user_id']);
    }
}
