<?php

namespace backend\modules\bhsx\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\bhsx\models\PesertaKompetisi;

/**
 * PesertaKompetisiSearch represents the model behind the search form about `backend\modules\bhsx\models\PesertaKompetisi`.
 */
class PesertaKompetisiSearch extends PesertaKompetisi
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['peserta_kompetisi_id', 'user_id', 'kompetisi_id', 'deleted'], 'integer'],
            [['nama_peserta', 'tanggal_lahir', 'jenis_kelamin', 'telp', 'asal_sekolah', 'alamat_sekolah', 'created_at', 'updated_at', 'created_by', 'updated_by', 'deleted_at', 'deleted_by'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = PesertaKompetisi::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'peserta_kompetisi_id' => $this->peserta_kompetisi_id,
            'user_id' => $this->user_id,
            'tanggal_lahir' => $this->tanggal_lahir,
            'kompetisi_id' => $this->kompetisi_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'deleted' => $this->deleted,
            'deleted_at' => $this->deleted_at,
        ]);

        $query->andFilterWhere(['like', 'nama_peserta', $this->nama_peserta])
            ->andFilterWhere(['like', 'jenis_kelamin', $this->jenis_kelamin])
            ->andFilterWhere(['like', 'telp', $this->telp])
            ->andFilterWhere(['like', 'asal_sekolah', $this->asal_sekolah])
            ->andFilterWhere(['like', 'alamat_sekolah', $this->alamat_sekolah])
            ->andFilterWhere(['like', 'created_by', $this->created_by])
            ->andFilterWhere(['like', 'updated_by', $this->updated_by])
            ->andFilterWhere(['like', 'deleted_by', $this->deleted_by]);

        return $dataProvider;
    }
}
