<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_pemenang_kompetisi".
 *
 * @property integer $pemenang_kompetisi_id
 * @property integer $peserta_kompetisi_id
 * @property string $nama_peserta
 * @property string $asal_sekolah
 * @property string $posisi_juara
 * @property integer $tahun_kompetisi
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property BhsxPesertaKompetisi $pesertaKompetisi
 */
class PemenangKompetisi extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_pemenang_kompetisi';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['peserta_kompetisi_id', 'nama_peserta', 'asal_sekolah', 'posisi_juara', 'tahun_kompetisi'], 'required'],
            [['peserta_kompetisi_id', 'tahun_kompetisi', 'deleted'], 'integer'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['nama_peserta', 'asal_sekolah'], 'string', 'max' => 40],
            [['posisi_juara'], 'string', 'max' => 10],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
            [['peserta_kompetisi_id'], 'exist', 'skipOnError' => true, 'targetClass' => PesertaKompetisi::className(), 'targetAttribute' => ['peserta_kompetisi_id' => 'peserta_kompetisi_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'pemenang_kompetisi_id' => 'Pemenang Kompetisi ID',
            'peserta_kompetisi_id' => 'Peserta Kompetisi ID',
            'nama_peserta' => 'Nama Peserta',
            'asal_sekolah' => 'Asal Sekolah',
            'posisi_juara' => 'Posisi Juara',
            'tahun_kompetisi' => 'Tahun Kompetisi',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPesertaKompetisi()
    {
        return $this->hasOne(PesertaKompetisi::className(), ['peserta_kompetisi_id' => 'peserta_kompetisi_id']);
    }
}
