<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_pembayaran_toefl".
 *
 * @property integer $pembayarantoefl_id
 * @property integer $peserta_toefl_id
 * @property string $tanggal_pembayaran
 * @property string $bukti_pembayaran
 * @property string $status_pembayaran
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property BhsxPesertaToefl $pesertaToefl
 */
class PembayaranToefl extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_pembayaran_toefl';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['peserta_toefl_id', 'tanggal_pembayaran', 'bukti_pembayaran', 'status_pembayaran'], 'required'],
            [['peserta_toefl_id', 'deleted'], 'integer'],
            [['tanggal_pembayaran', 'created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['bukti_pembayaran'], 'string', 'max' => 100],
            [['status_pembayaran'], 'string', 'max' => 20],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
            [['peserta_toefl_id'], 'exist', 'skipOnError' => true, 'targetClass' => PesertaToefl::className(), 'targetAttribute' => ['peserta_toefl_id' => 'peserta_toefl_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'pembayarantoefl_id' => 'Pembayarantoefl ID',
            'peserta_toefl_id' => 'Peserta Toefl ID',
            'tanggal_pembayaran' => 'Tanggal Pembayaran',
            'bukti_pembayaran' => 'Bukti Pembayaran',
            'status_pembayaran' => 'Status Pembayaran',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPesertaToefl()
    {
        return $this->hasOne(PesertaToefl::className(), ['peserta_toefl_id' => 'peserta_toefl_id']);
    }
}
