<?php

namespace backend\modules\bhsx\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\bhsx\models\BiayaToefl;

/**
 * BiayaToeflSearch represents the model behind the search form about `backend\modules\bhsx\models\BiayaToefl`.
 */
class BiayaToeflSearch extends BiayaToefl
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['biaya_id'], 'integer'],
            [['membership', 'biaya_test'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = BiayaToefl::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'biaya_id' => $this->biaya_id,
        ]);

        $query->andFilterWhere(['like', 'membership', $this->membership])
            ->andFilterWhere(['like', 'biaya_test', $this->biaya_test]);

        return $dataProvider;
    }
}
