<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;
use Response;
use Redirect;
use Session;
use App\verifikasis_m;
use Illuminate\Support\Facades\DB;



class verifikasis_mController extends Controller {



    public function index() {
      $verifikasis_m = DB::table('verifikasi_masalah')->paginate(10);
      
        return view('verifikasiMasalah.index',['verifikasis_m' => $verifikasis_m]);
    }


      public function create()
    {
       return view('verifikasiMasalah.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['nama'=> 'required',]);

        $verifikasiMasalah = new verifikasis_m;
        $verifikasiMasalah->nama = $request->nama;
        $verifikasiMasalah->save();
        return redirect()->route('verifikasiMasalah.index')->with('alert-success','Data Hasbeen Saved');
    }


    public function multiple_upload() {
      // getting all of the post data
      $files = Input::file('images');
      // Making counting of uploaded images
      $file_count = count($files);
      // start count how many uploaded
      $uploadcount = 0;

      foreach ($files as $file) {
        $rules = array('file' => 'required'); //'required|mimes:png,gif,jpeg,txt,pdf,doc'
        $validator = Validator::make(array('file'=> $file), $rules);
        if($validator->passes()){
          $destinationPath = 'verifikasis_m'; // upload folder in public directory
          $filename = $file->getClientOriginalName();
          $upload_success = $file->move($destinationPath, $filename);
          $uploadcount ++;

          // save into database
          $extension = $file->getClientOriginalExtension();
          $entry = new verifikasis_m();
          $entry->mime = $file->getClientMimeType();
          $entry->original_filename = $filename;
          $entry->filename = $file->getFilename().'.'.$extension;
          $entry->save();
        }
      }
      if($uploadcount == $file_count){
        Session::flash('success', 'Upload successfully');
        return Redirect::to('verifikasiMasalah');
      } else {
        return Redirect::to('verifikasiMasalah')->withInput()->withErrors($validator);
      }
    }


     public function destroy($id)
    {
         $verifikasiMasalah = verifikasis_m::findOrFail($id);
        $verifikasiMasalah->delete();
        return redirect()->route('verifikasiMasalah.index')->with('alert-success','Data Hasbeen Deleted');  
    }



} 