<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;
use Response;
use Redirect;
use Session;
use App\UpLoadrt;

use DB;

class UploadrtController extends Controller {



    public function index() {
      
      $uploadrt = DB::table('laporanTransaksiReceptionist')->paginate(10);
        return view('laporanTransaksiReceptionist.index',['uploadrt' => $uploadrt]);
    }


      public function create()
    {
       return view('laporanTransaksiReceptionist.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['nama'=> 'required',]);

        $laporanTransaksiReceptionist = new uploadrt;
        $laporanTransaksiReceptionist->nama = $request->nama;
        $laporanTransaksiReceptionist->save();
        return redirect()->route('laporanTransaksiReceptionist.index')->with('alert-success','Data Hasbeen Saved');
    }


    public function multiple_upload() {
      // getting all of the post data
      $files = Input::file('images');
      // Making counting of uploaded images
      $file_count = count($files);
      // start count how many uploaded
      $uploadcount = 0;

      foreach ($files as $file) {
        $rules = array('file' => 'required'); //'required|mimes:png,gif,jpeg,txt,pdf,doc'
        $validator = Validator::make(array('file'=> $file), $rules);
        if($validator->passes()){
          $destinationPath = 'uploadrt'; // upload folder in public directory
          $filename = $file->getClientOriginalName();
          $upload_success = $file->move($destinationPath, $filename);
          $uploadcount ++;

          // save into database
          $extension = $file->getClientOriginalExtension();
          $entry = new uploadrt();
          $entry->mime = $file->getClientMimeType();
          $entry->original_filename = $filename;
          $entry->filename = $file->getFilename().'.'.$extension;
          $entry->save();
        }
      }
      if($uploadcount == $file_count){
        Session::flash('success', 'Upload successfully');
        return Redirect::to('laporanTransaksiReceptionist');
      } else {
        return Redirect::to('laporanTransaksiReceptionist')->withInput()->withErrors($validator);
      }
    }


     public function destroy($id)
    {
         $laporanTransaksiReceptionist = Uploadrt::findOrFail($id);
        $laporanTransaksiReceptionist->delete();
        return redirect()->route('laporanTransaksiReceptionist.index')->with('alert-success','Data Hasbeen Deleted');  
    }



} 